
const { Op } = require("sequelize");
const { vendorReviews,users} = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class vendorReviewsService{

    async getReviewsBOfVendor (id, obj) {
        
        const { page = 0, pageSize = 10, orderBy = 'id', order = 'DESC' } = obj;
        const { start, end } = getLimitForPagination(page, pageSize);
        const whereCondition = {
        vendor_id: id
    };
      let reviews = await vendorReviews.findAll({
        where:whereCondition,
        include: [{
          model: users,
          attributes: ['name'] // Include only the 'name' attribute from the user table
      }],
        offset: start, limit: end,
        order: [[orderBy, order]]
      });
      const totalCount = await vendorReviews.count({
        where: whereCondition,
      });
  
      return {reviews , totalCount , page , pageSize};    
}

getReviewsByVendorId = async (req, res) => {
    try {
      const {reviews , totalCount, page , pageSize} = await this.getReviewsBOfVendor(req.params.id, req.query);
      return genPagingResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, reviews, page, totalCount, pageSize);
    } catch (e) {
      console.log(e);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, e.message);

    }
  }

}
module.exports = vendorReviewsService;