const { Op } = require("sequelize");
const { vendorPackages } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class VendorPackagesService {
    // Create
 createVendorPackage = async (req,res) => {
        try {
            const {name, vendorId,details,price,bookingPrice}= req.body;
            if (!name || !vendorId ||!price ||!bookingPrice) {
                return genResponse(res, HTTP_STATUS_CODES.ERROR, RESPONSE_MSG.RPM);
               }
            let data={
                name: name,
                vendor_id:vendorId,
                details:details,
                price: price,
                booking_price:bookingPrice
            }
            const result = await vendorPackages.create(data);
            return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
        } catch (e) {
            return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
        }
    };
    
    // Read
 getAllVendorPackages = async (req, res) => {
        try {
            const result = await vendorPackages.findAll();
            return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
        } catch (error) {
            throw new Error('Could not fetch vendor packages');
        }
    };

  getVendorPackagesByVendorId = async (req, res) => {
        try {
            if (!req.query.vendorId) {
                return genResponse(res, HTTP_STATUS_CODES.ERROR, RESPONSE_MSG.RPM);
               }
            const result = await vendorPackages.findAll({
                where: {
                    vendor_id: req.query.vendorId
                }
            });
            return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
        } catch (e) {
            return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
        }
    }  
    
  getVendorPackageById = async (req, res) => {
            try {
            if (!req.body.id) {
             return genResponse(res, HTTP_STATUS_CODES.ERROR, RESPONSE_MSG.RPM);
            }
            const result = await vendorPackages.findByPk(id);
            return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);;
         } catch (e) {
            return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
        }
    }
    
    // Update
 updateVendorPackage = async (req, res) => {
        try {
            const {id, name, vendorId,details,price,bookingPrice}=req.body;

            if (!id || !vendorId) {
                return genResponse(res, HTTP_STATUS_CODES.ERROR, RESPONSE_MSG.RPM);
              }  
            const vendorPackage = await vendorPackages.findByPk(id);
            if (!vendorPackage) throw new Error('Vendor package not found');
            const data={
                name: name,
                vendor_id: vendorId,
                details: details,
                price: price,
                booking_price: bookingPrice
            }
            await vendorPackage.update(data);
            return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, vendorPackage);
        } catch (e) {
            return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
        }
    };
    
    // Delete
  deleteVendorPackage = async (req, res) => {
        try {
          if (!req.body.vendorId || !req.body.packageId) {
            return genResponse(res, HTTP_STATUS_CODES.ERROR, RESPONSE_MSG.RPM);
          }
          const result = await vendorPackages.update({ active: false }, {
            where: {
              vendor_id: req.body.vendorId,
              id: req.body.packageId // Only delete images with IDs in the provided array
            }
          });
    
          if (isEmpty(result)) {
            return genResponse(res, HTTP_STATUS_CODES.NOT_FOUND, RESPONSE_MSG.NOT_FOUND, 'not deleted');
          }
          return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS_DEL);
        } catch (e) {
          return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
        }
      }
}

module.exports = VendorPackagesService;
