
const { Op } = require("sequelize");
const { locations } = require("../models/dbCon");
const { genResponse, isEmpty, getLimitForPagination, genPagingResponse } = require("../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../commons/constants");

class LocationService {

  getAll = async (req, res) => {
    try {
      let result = await locations.findAll();
      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
    }
    catch (e) {
        return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
    }
  }

  getlocationById = async (req, res) => {
    try {
      const locationId  = req.params.locationId;
      if (locationId) {
        let result = await locations.findByPk(req.params.locationId)
        if (!result) {
          return genResponse(res, HTTP_STATUS_CODES.NOT_FOUND, RESPONSE_MSG.NOT_FOUND, 'location is not found');
        }
        return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
      }
    }
    catch (e) {
        return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
    }
  }
}


module.exports = LocationService;