var express = require('express');
var app = express();
const routes = require('./controller');
var cors = require('cors');
const dotenv = require('dotenv');
const logger = require('./utils/logger');
const swaggerUi = require('swagger-ui-express');
const specs = require('./swagger/swaggerSpecs'); // Import the Swagger specification
require('./models/dbCon');
const http = require('http');
require('dotenv/config');


// use it before all route definitions
app.use(cors({origin: '*'}));
app.use(express.urlencoded( {extended: true} ));
app.use(express.json());
app.use('/Images', express.static('./Images'))
app.use(logger);
dotenv.config();

app.use(function (req, res, next) {
  res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
  res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
  next();
});
// Serve Swagger UI on /api-docs endpoint
app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(specs));
app.use(routes);

app.get('/', function (req, res) {
  res.send('server Started')
});

const servers = http.createServer(app);



var server = servers.listen(process.env.PORT || 9090, function () {
  var host = server.address().address
  var port = server.address().port
  console.log("Example app listening at http://%s:%s", host, port);
})
