const router = require("express").Router();
const multipart = require('connect-multiparty');
const VendorReviewsService = require("../../services/vendorServices/VendorReviewService.js");
const Verify = require('../../services/VendorVerifyToken.js');


let vendorReviewsService =new VendorReviewsService();

/**
 * @swagger
 * tags:
 *   name: VendorReviews
 *   description: API for managing products reviews
 */


/**
 * @swagger
 * /api/vendorReviews/view/{id}:
 *   get:
 *     summary: Get  Reviews
 *     tags: [VendorReviews]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: integer
 *         description: ID of the vendors to retrieve
 *       - in: query
 *         name: page
 *         description: Page number for pagination | default value 0
 *         schema:
 *           type: integer
 *       - in: query
 *         name: pageSize
 *         description: Number of items per page| default value 10
 *         schema:
 *           type: integer
 *       - in: query
 *         name: orderBy
 *         description: column name for order by| default value id
 *         schema:
 *           type: string
 *       - in: query
 *         name: order
 *         description: order ASC or DESC| default value DESC
 *         schema:
 *           type: string
 *     security:
 *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
 *     responses:
 *       200:
 *         description: Successful response
 */
router.get('/view/:id',Verify, async function (req, res) {
    try {
        await vendorReviewsService.getReviewsByVendorId(req  ,res);
    }
    catch (e) {
        console.log(e);
    }
});








module.exports = router;