const router = require("express").Router();
const SubscriptionService = require("../../services/vendorServices/SubscriptionService.js");
const multipart = require('connect-multiparty');
const Verify = require('../../services/VendorVerifyToken.js');



let subscriptionService = new SubscriptionService()

/**
 * @swagger
 * tags:
 *   name: Subscription
 *   description: API endpoints for managing Subscription
 */

/**
 * @swagger
 * /api/subscription/getAllsubscriptionPlan:
 *   get:
 *     summary: Get all subscription plans or get a subscription plan by  subType
 *     description: Retrieve all available subscription plans or a specific subscription plan by its ID.
 *     tags: [Subscription]
 *     parameters:
 *       - in: query
 *         name: subType
 *         schema:
 *         type: integer
 *         description: Optional. subType of the subscription plan to retrieve.
 *     security:
 *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
 *     responses:
 *       '200':
 *         description: A list of subscription plans or a single subscription plan.
 *       '404':
 *         description: Subscription plan not found.
 *       '500':
 *         description: Internal server error.
 */

router.get('/getAllsubscriptionPlan', Verify, async function (req, res) {
    try {
        await subscriptionService.getAllsubscriptionPlan(req, res);
    }
    catch (e) {
        console.log(e);
    }
});

/**
 * @swagger
 * /api/subscription/subscribePlan:
 *   post:
 *     summary: Subscribe to a plan
 *     tags: [Subscription]
 *     consumes:
 *       - application/json
 *     produces:
 *       - application/json
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               name:
 *                 type: string
 *                 description: Name of the plan
 *               price:
 *                 type: string
 *                 description: price of the plan
 *               sub_plan_id:
 *                 type: integer
 *                 description: ID of the subscription plan
 *               vendor_id:
 *                 type: integer
 *                 description: ID of the vendor
 *               month:
 *                 type: integer
 *                 description: Number of months for the subscription
 *     security:
 *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
 *     responses:
 *       '200':
 *         description: Subscription buy successfully.
 *       '400':
 *         description: Bad Request. Missing required fields.
 *       '500':
 *         description: Internal Server Error.
 */

router.post('/subscribePlan', Verify,async function (req, res) {
    try {
        await subscriptionService.SubscribePlan(req, res)
    }
    catch (e) {
        console.log(e);
    }
});



module.exports = router;