const router = require('express').Router();
const Response = require('../../models/Response.js');
const NotificationService = require("../../services/vendorServices/NotificationService.js");
const Verify = require('../../services/VendorVerifyToken.js');

const notificationService = new NotificationService();
/**
 * @swagger
 * tags:
 *   name: Notification
 *   description: API for managing authentication
 */

/**
 * @swagger
 * /api/notification/{id}:
 *   get:
 *     summary: Get Leads By vendorId for vendor app
 *     tags: [Notification]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: VendorId  of the Leads
 *     security:
 *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
 *     responses:
 *       '200':
 *         description: Successful response
 *       '404':
 *         description: Subscription plan not found.
 *       '500':
 *         description: Internal server error.
 */

router.get('/:id',Verify, async function (req, res) {
    await notificationService.getNotificationVendorId(req, res);
});


module.exports = router;