const router = require('express').Router();
const Response = require('../../models/Response.js');
const CusLeadsService = require("../../services/customerServices/CustomerLeadsService.js");
const Verify = require('../../services/CustomerVerifyToken.js');

const cusleadsService = new CusLeadsService();

/**
 * @swagger
 * tags:
 *   name: Customer APP APIs
 */

/**
 * @swagger
 * /api/customerLeads:
 *   post:
 *     summary: Create a new lead
 *     tags: [Customer APP APIs]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               user_id:
 *                 type: integer
 *                 description: ID of the user
 *               vendor_id:
 *                 type: integer
 *                 description: ID of the vendor
 *               leads_contact_type:
 *                 type: string
 *                 description: Type of lead contact
 *               phone:
 *                 type: string
 *                 description: Phone number
 *               name:
 *                 type: string
 *                 description: Name of the lead
 *               email:
 *                 type: string
 *                 description: Email of the lead
 *               details:
 *                 type: string
 *                 description: Additional details about the lead
 *               lead_date:
 *                 type: string
 *                 format: date
 *                 description: Date of the lead
 *             required:
 *               - user_id
 *               - vendor_id
 *               - leads_contact_type
 * 
 *     security:
 *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
 *     responses:
 *       '201':
 *         description: Lead created successfully
 *       '400':
 *         description: Bad request. Missing required parameters.
 *       '500':
 *         description: Internal server error.
 */
router.post('/', Verify,async function (req, res) {
    await cusleadsService.addLeads(req, res)
});

module.exports = router;
