const { Op } = require("sequelize");
const { auth, users, vendors, locations, addresses, vendorCatBridge,vendorMedia, questions, vendorsAnswers, notification } = require("../../models/dbCon");
const vendorService = require("../vendorServices/vendorService");
const { genResponse, isEmpty } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");
// const AuthResponseDto = require("../models/responseDto/authResponseDto");
const SmsServices = require("../SmsService");
const jwt = require("jsonwebtoken");
const csv = require("csv-parser");
const fs = require("fs");

class AuthService {
  // constructor() {
  //   this.vendorService = new vendorService();
  // }

  async authUser(req, res) {
    try {
      // Get user input
      const { userType, phone } = req.body;

      // Check if phone number is provided
      if (!phone || !userType) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, "Phone number is required", "");
      }

      // Check if the user account exists
      let account = await auth.findOne({
        where: {
          phone: phone,
          user_type: userType,
          active: true,
        },
      });

      let result;

      if (account) {
        let randomCode;
        if (phone == '03030502620') {
          randomCode = 1234;
        } else {
          // Generate and update verification code
          // randomCode = Math.floor(1000 + Math.random() * 9000);
          randomCode = 1234;
        }

        await auth.update({ code: randomCode }, { where: { phone: phone, user_type: userType } });

        if (phone != '03030502620') {
          // const data = await SmsServices.sendsms(phone, randomCode, null);
          // if (data.STATUS == 'SUCCESSFUL') {
            result = {
              message: 'Verification code sent successfully',
              data: { phone, userType }
            };
          // }
          // else {
          //   return genResponse(res, HTTP_STATUS_CODES.ERROR, 'ERROR', data);
          // }
        }
        else {
          result = {
            message: 'Verification code sent successfully',
            data: { phone, userType }
          };
        }

      } else {
        // Generate verification code and create new user account

        let randomCode;
        if (phone == '03030502620') {
          randomCode = 1234;
        } else {
          // Generate and update verification code
          // randomCode = Math.floor(1000 + Math.random() * 9000);
          randomCode = 1234;

        }
        const authData = { phone, code: randomCode, user_type: userType };
        const newUser = await auth.create(authData);

        if (newUser) {
          // Assuming you have an SMS service to send verification code
          if (phone != '03030502620') {
            // const data = await SmsServices.sendsms(phone, randomCode, null);
            // if (data.STATUS == 'SUCCESSFUL') {
              result = {
                message: 'User account created successfully',
                data: newUser
              };
            // }
            // else {
            //   return genResponse(res, HTTP_STATUS_CODES.ERROR, 'ERROR', data);
            // }
          }
          else {
            result = {
              message: 'Verification code sent successfully',
              data: { phone, userType }
            };
          }
        } else {
          return genResponse(res, HTTP_STATUS_CODES.FORBIDDEN, RESPONSE_MSG.ECUA, "");
        }
      }
      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
    } catch (error) {
      console.error(error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.ISE, error);
    }
  }

  async verifyUser(req, res) {
    try {
      const { phoneNumber, code, userType } = req.body;
      if (!(phoneNumber && code && userType)) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, "");
      }
      const user = await auth.findOne({ where: { code, phone: phoneNumber, user_type: userType } });
      if (user) {
        await auth.update({ active: true, code: null }, { where: { phone: phoneNumber, user_type: userType } });
        let result;
        let token;
        let userDetail;

        if (!user.is_account_verified) {
          result = { data: user };
        } else if (user.user_type === "customer") {
          token = jwt.sign({ user_id: phoneNumber, role: "customer" }, process.env.JWT_SECRET2);
          userDetail = await users.findAll({
            where: { phone: phoneNumber },
            include: [{
              model: locations, // Replace 'locations' with your actual model name
              attributes: ['name'] // Specify the attributes you want to include from the location model
            }]
          });
          result = {
            access_token: token,
            refresh_token: "", // Assuming you implement refresh tokens
            expiry: "",
            data: user,
            userDetail: userDetail,
          };
        } else {
          token = jwt.sign({ user_id: phoneNumber, role: "vendor" }, process.env.JWT_SECRET);
          let userDetail = await vendors.findAll({
            where: { phone: phoneNumber },
            include: [{
              model: addresses, // Replace 'addresses' with your actual model name
              attributes: ['full_address'], // Specify the attributes you want to include from the location model
              include: [{
                model: locations, // Replace 'locations' with your actual model name
                attributes: ['name'] // Specify the attributes you want to include from the location model
              }]
            }]
          });
          result = {
            access_token: token,
            refresh_token: "", // Assuming you implement refresh tokens
            expiry: "",
            data: user,
            userDetail: userDetail,
          };
        }
        return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
      } else {
        return genResponse(res, HTTP_STATUS_CODES.FORBIDDEN, "Incorrect Code", "");
      }
    } catch (error) {
      console.error(error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Internal Server Error", error);
    }
  }

  async profileSetup(req, res) {
    try {
      const { phone, businessName, name, parentId, categoryIds, userType, businessphone, locationId, address } = req.body;

      if (!phone || !userType) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, "");
      }

      if (userType === "vendor") {
        if (!businessName || !businessphone || !parentId) {
          return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, "");
        }

        const addressData = {
          full_address: address,
          lat: "",
          log: "",
          location_id: locationId,
        };
        const createdAddress = await addresses.create(addressData);

        const vendorData = {
          business_name: businessName,
          name: name,
          address_id: createdAddress.id,
          phone: phone,
          business_phone: businessphone,
          user_type: userType,
        };

        // Initialize categoryArray with categoryIds or an empty array
        const categoryArray = categoryIds && categoryIds.length > 0 ? [...categoryIds] : [];
        // If parentId is not already included in categoryArray, add it
        if (!categoryArray.includes(parentId)) {
          categoryArray.push(parentId);
        }
        const vendor = await vendors.create(vendorData);

        if (vendor) {
          const bulkInsertData = categoryArray.map((categoryId) => ({
            vendor_id: vendor.id,
            vendor_category_id: categoryId,
            is_parent: categoryId === parentId ? true : false,
          }));
          await vendorCatBridge.bulkCreate(bulkInsertData);
          await auth.update({ is_account_verified: true, code: null }, { where: { phone: phone, user_type: userType } });
          const user = await auth.findOne({ where: { phone: phone, user_type: userType } });
          let token = jwt.sign({ user_id: phone, role: "vendor" }, process.env.JWT_SECRET);
          let userDetail = await vendors.findAll(
            {
              where: { phone: phone },
              include: [{
                model: addresses, // Replace 'addresses' with your actual model name
                attributes: ['full_address'], // Specify the attributes you want to include from the location model
                include: [{
                  model: locations, // Replace 'locations' with your actual model name
                  attributes: ['name'] // Specify the attributes you want to include from the location model
                }]
              }]
            });
          const result = {
            access_token: token,
            refresh_token: "", // Assuming you implement refresh tokens
            expiry: "",
            data: user,
            userDetail: userDetail,
          };
          return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
        } else {
          return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Error Creating Vendor Account", result);
        }
      } else if (userType === "customer") {
        if (!name || !locationId) {
          return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, "");
        }
        const customerData = {
          name: name,
          phone: phone,
          user_type: userType,
          location_id: locationId,
        };
        const customer = await users.create(customerData);

        if (customer) {
          await auth.update({ is_account_verified: true, code: null }, { where: { phone: phone, user_type: userType } });
          const user = await auth.findOne({ where: { phone: phone, user_type: userType } });
          let token = jwt.sign({ user_id: phone, role: "customer" }, process.env.JWT_SECRET2);
          let userDetail = await users.findAll({
            where: { phone: phone },
            include: [{
              model: locations, // Replace 'locations' with your actual model name
              attributes: ['name'] // Specify the attributes you want to include from the location model
            }]
          });
          const result = {
            access_token: token,
            refresh_token: "", // Assuming you implement refresh tokens
            expiry: "",
            data: user,
            userDetail: userDetail,
          };
          return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
        } else {
          return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Error Creating Customer Account", result);
        }
      } else {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, "Invalid User Type", "");
      }
    } catch (error) {
      console.error(error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Internal Server Error", error);
    }
  }

  async resendCode(req, res) {
    try {
      const { phoneNumber, userType } = req.body;
      if (!(phoneNumber && userType)) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, "");
      }
      let account = await auth.findOne({
        where: {
          phone: phoneNumber,
          user_type: userType,
          active: true,
        },
      });

      let result;
      if (account) {
        let randomCode;
        if (phoneNumber == "03030502620") {
          randomCode = 1234;
        } else {
          // Generate and update verification code
          randomCode = Math.floor(1000 + Math.random() * 9000);
        }

        await auth.update({ code: randomCode }, { where: { phone: phoneNumber, user_type: userType } });
        if (phoneNumber != "03030502620") {
          const data = await SmsServices.sendsms(phoneNumber, randomCode, null);
          if (data.STATUS == "SUCCESSFUL") {
            result = {
              message: "Verification code sent successfully",
              data: { phoneNumber, userType },
            };
          } else {
            return genResponse(res, HTTP_STATUS_CODES.ERROR, "ERROR", data);
          }
        }
        else {
          result = {
            message: "User account created successfully",
            data: newUser,
          };
        }

      }
      else {
        return genResponse(res, HTTP_STATUS_CODES.ERROR, 'ERROR', data);
      }

      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
    } catch (error) {
      console.error(error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Internal Server Error", error);
    }
  }

  updateNotificationToken = async (req, res) => {
    try {
      const { phone, newNotificationToken, userType } = req.body;
      if (!(phone && userType)) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, "");
      }
      if (userType === 'customer') {
        // Update the users table
        let user = await users.findOne({ where: { phone: phone } });

        if (user) {
          user.notification_token = newNotificationToken;
          await user.save();

          const result = {
            message: "Notification token updated successfully",
            data: {
              notificationToken: user.notification_token
            }
          };
          return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);

        } else {
          return genResponse(res, HTTP_STATUS_CODES.FORBIDDEN, "User not found in users table.", "");
        }
      } else if (userType === 'vendor') {
        // Update the vendors table
        let vendor = await vendors.findOne({ where: { phone: phone } });

        if (vendor) {
          vendor.notification_token = newNotificationToken;
          await vendor.save();
          const result = {
            message: "Notification token updated successfully",
            data: {
              notificationToken: vendor.notification_token
            }
          };
          return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);

        } else {
          return genResponse(res, HTTP_STATUS_CODES.FORBIDDEN, "Vendor not found in users table.", "");
        }
      } else {
        console.log('Invalid user type.');
      }
    } catch (error) {
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Internal Server Error", error);
    }
  };

  async InsertVendorFromCSV(req, res) {
    try {
      if (!req.file) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, "CSV file is required", "");
      }

      // ✅ Get values from user input (body)
      const { parentId, locationId, categoryArray } = req.body;
      let parsedCategoryArray = [];

      // ✅ Handle multiple possible input types safely
      if (Array.isArray(categoryArray)) {
        parsedCategoryArray = categoryArray;
      } else if (typeof categoryArray === 'string') {
        try {
          // Try to parse as JSON (e.g., "[1,2,3]")
          const temp = JSON.parse(categoryArray);
          parsedCategoryArray = Array.isArray(temp)
            ? temp
            : categoryArray.split(',').map((item) => item.trim());
        } catch {
          // Fallback if it's a comma-separated string like "1,2,3"
          parsedCategoryArray = categoryArray
            .split(',')
            .map((item) => item.trim())
            .filter((item) => item.length > 0);
        }
      } else if (typeof categoryArray === 'number') {
        parsedCategoryArray = [categoryArray];
      }


      // ✅ Validate user input
      if (!parentId || !locationId || !Array.isArray(parsedCategoryArray) || parsedCategoryArray.length === 0) {
        return genResponse(
          res,
          HTTP_STATUS_CODES.BAD_REQUEST,
          "parentId, locationId, and categoryArray are required and must be valid",
          ""
        );
      }


      const filePath = req.file.path;
      const results = [];
      const vendorsToInsert = [];

      // Step 1: Parse CSV with correct field mappings
      await new Promise((resolve, reject) => {
        fs.createReadStream(filePath)
          .pipe(csv())
          .on("data", (row) => {
            vendorsToInsert.push({
              businessName: row['Name'] || '',
              name: row['Name'] || '',
              address: row['Location'] || '',
              phone: row['Contact'] || '',
              businessphone: row['Contact'] || '',
              f_price: row['F_Price'] || '',
              facebook: row['Facebook'] || '',
              instagram:row['Instagram'] || '',
              // total_Capicity: row['Total_Capicity'] || '',
              Female_Photographer: row['Female_Photographer'] || '',
              Service_Area: row['Service_Area'] || '',
              // Parking: row['Parking'] || '',

            });
          })
          .on("end", resolve)
          .on("error", reject);
      });

      if (!Array.isArray(vendorsToInsert) || vendorsToInsert.length === 0) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, "CSV contains no valid vendor rows", "");
      }

      // Step 2: Load all questions once
      const allQuestions = await questions.findAll({ where: { status: 1 } });

      // Step 3: Process Each Vendor
      for (const vendorInput of vendorsToInsert) {
        const {
          phone,
          businessName,
          name,
          businessphone,
          address,
          f_price,
          facebook,
          instagram,
          Female_Photographer,
          Service_Area,
          total_Capicity,
          Parking
        } = vendorInput;

        // const parentId = 1;
        // const locationId = 1;
        const userType = "vendor";

        // const categoryArray = [3];
        if (!parsedCategoryArray.includes(parentId)) parsedCategoryArray.push(parentId);

        if (!phone || !userType || !businessName || !businessphone) {
          results.push({ phone, success: false, message: "Missing required fields" });
          continue;
        }

        // Check for duplicate vendor by phone
        const existing = await vendors.findOne({ where: { phone } });
        if (existing) {
          results.push({ phone, success: false, message: "Vendor already exists" });
          continue;
        }

        // Step 4: Create Address
        const addressData = {
          full_address: address,
          lat: "",
          long: "",
          location_id: locationId,
        };
        const createdAddress = await addresses.create(addressData);

        // Step 5: Create Vendor
        const vendorData = {
          business_name: businessName,
          name: name,
          address_id: createdAddress.id,
          phone: phone,
          f_price: f_price || '',
          business_phone: businessphone,
          instagram_page_link: instagram || '',
          user_type: userType,
          facebook_page_link: facebook || ''
        };
        const vendor = await vendors.create(vendorData);

        if (!vendor) {
          results.push({ phone, success: false, message: "Failed to create vendor" });
          continue;
        }

        // Step 6: Create Category Mapping
        const bulkInsertData = parsedCategoryArray.map((categoryId) => ({
          vendor_id: vendor.id,
          vendor_category_id: categoryId,
          is_parent: categoryId === parentId
        }));
        await vendorCatBridge.bulkCreate(bulkInsertData);

        // ✅ Step 7: Create Vendor Media (Insert only one cover photo)
        const mediaUrl = "cover/cover.jpg"
        const mediaData = {
          sequence: 1,
          is_banner: true,
          type:'image/jpeg',
          path: mediaUrl,
          image_type: 'cover',
          vendor_id: vendor.id,
          subvendor_id: null,
          album_id: null
        };
        await vendorMedia.create(mediaData);


        // ✅ Step 8: Insert vendor answers
        const answerInserts = allQuestions
          .map((q) => {
            let answer = "";
            // Map CSV data to matching question
            // if (q.question === "What is the rental cost for the venue?" && f_price !== '') {
            //   answer = f_price;
            // } else if (q.question === "What is the maximum capacity of your venue? (Without Buffet)" && total_Capicity !== '') {
            //   answer = total_Capicity;
            // } else if (q.question === "What is the maximum capacity of your venue? (With Buffet)" && total_Capicity !== '') {
            //   answer = total_Capicity;
            // } else if (q.question === "Is parking available at the venue?" && Parking !== '') {
            //   answer = Parking;
            // }
            if (q.question === "Do you provide female photographer?" && Female_Photographer !== '') {
              answer = Female_Photographer;
            }
            else if (q.question === "Service Areas?" && Service_Area !== '') {
              answer = Service_Area;
            }


            return {
              vendor_id: vendor.id,
              question_id: q.id,
              answers: answer,
              status: true,
            };
          })
          // ✅ Filter out empty answers before inserting
          .filter((a) => a.answers && a.answers.trim() !== "");

        if (answerInserts.length > 0) {
          await vendorsAnswers.bulkCreate(answerInserts);
        }

        results.push({ phone, success: true, message: "Vendor created successfully" });
      }

      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, { summary: results });

    } catch (error) {
      console.error(error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, "Internal Server Error", error);
    }
  }

}

module.exports = AuthService;
