// Step 1: Import the S3Client object and all necessary SDK commands.
//import { PutObjectCommand, S3Client } from '@aws-sdk/client-s3';
const { PutObjectCommand, S3Client } = require('@aws-sdk/client-s3')
const fs = require('fs');
require('dotenv/config');

// Step 2: The s3Client function validates your request and directs it to your Space's specified endpoint using the AWS SDK.
const s3Client = new S3Client({
  endpoint: process.env.S3_BUCKET_ENDPOINT,//"https://nyc3.digitaloceanspaces.com", // Find your endpoint in the control panel, under Settings. Prepend "https://".
  forcePathStyle: false, // Configures to use subdomain/virtual calling format.
  region: process.env.S3_BUCKET_REGION,//"us-east-1", // Must be "us-east-1" when creating new Spaces. Otherwise, use the region in your endpoint (e.g. nyc3).
  credentials: {
    accessKeyId: process.env.S3_BUCKET_KEYID, // Access key pair. You can create access key pairs using the control panel or API.
    secretAccessKey: process.env.S3_BUCKET_KEY//process.env.SPACES_SECRET // Secret access key defined through an environment variable.
  }
});


// Step 3: Define the parameters for the object you want to upload.
/*const params = {
  Bucket: "hydimages", // The path to the directory you want to upload the object to, starting with your Space name.
  Key: "Images/hello-world.txt", // Object key, referenced whenever you want to access this file later.
  Body:"Hello, World!", // The object's contents. This variable is an object, not a string.
  ACL: "private", // Defines ACL permissions, such as private or public.
  Metadata: { // Defines metadata tags.
    "x-amz-meta-my-key": "your-value"
  }
};*/


// Step 4: Define a function that uploads your object using SDK's PutObjectCommand object and catches any errors.
const uploadObject = async (params) => {
  try {
    const data = await s3Client.send(new PutObjectCommand(params));
    console.log(
      "Successfully uploaded object: " +
      params.Bucket +
      "/" +
      params.Key
    );
    return data;
  } catch (err) {
    console.log("Error", err);
  }
};

const uploadFiles = async (files) => {
  let uploadFileNames = [];
  for (const file of files) {
    let imageName = "shaadi_bazaar/" + Date.now() + file.files.originalFilename;
    let params = {
      Bucket: "bucket.wedeasy.pro", // The path to the directory you want to upload the object to, starting with your Space name.
      Key: imageName, // Object key, referenced whenever you want to access this file later.
      Body: fs.createReadStream(file.files.path), // The object's contents. This ariable is an object, not a string.
      ACL: "public-read", // Defines ACL permissions, such as private or public.
      Metadata: { // Defines metadata tags.
        "x-amz-meta-my-key": "your-value"
      }
    };
    uploadObject(params);
    uploadFileNames.push(imageName)
  }
  return uploadFileNames;
}

const uploadFile = async (fileName, filePath) => {

  let uploadFileName = "shaadi_bazaar/" + Date.now() + fileName;
  let params = {
    Bucket: "bucket.wedeasy.pro", // The path to the directory you want to upload the object to, starting with your Space name.
    Key: uploadFileName, // Object key, referenced whenever you want to access this file later.
    Body: fs.createReadStream(filePath), // The object's contents. This variable is an object, not a string.
    ACL: "public-read", // Defines ACL permissions, such as private or public.
    Metadata: { // Defines metadata tags.
      "x-amz-meta-my-key": "your-value"
    }
  };
  uploadObject(params);
  return uploadFileName;
}

const uploadFileToFolder = async (fileName, filePath , folder) => {

  if(fileName.includes(',')){
    fileName = fileName.replace(',','');
  }
  let uploadFileName = folder +'/'+ Date.now() + fileName;
  let params = {
    Bucket: "bucket.wedeasy.pro", // The path to the directory you want to upload the object to, starting with your Space name.
    Key: uploadFileName, // Object key, referenced whenever you want to access this file later.
    Body: fs.createReadStream(filePath), // The object's contents. This variable is an object, not a string.
    // ACL: "public-read", // Defines ACL permissions, such as private or public.
    Metadata: { // Defines metadata tags.
      "x-amz-meta-my-key": "your-value"
    }
  };
  uploadObject(params);
  return uploadFileName;
}

// Step 5: Call the uploadObject function.
//uploadObject();


module.exports = {
  uploadFile , 
  uploadFileToFolder
};