"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PortingPortInPhoneNumberListInstance = exports.PortingPortInPhoneNumberContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class PortingPortInPhoneNumberContextImpl {
    constructor(_version, portInRequestSid, phoneNumberSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(portInRequestSid)) {
            throw new Error("Parameter 'portInRequestSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(phoneNumberSid)) {
            throw new Error("Parameter 'phoneNumberSid' is not valid.");
        }
        this._solution = { portInRequestSid, phoneNumberSid };
        this._uri = `/Porting/PortIn/${portInRequestSid}/PhoneNumber/${phoneNumberSid}`;
    }
    remove(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PortingPortInPhoneNumberContextImpl = PortingPortInPhoneNumberContextImpl;
function PortingPortInPhoneNumberListInstance(version) {
    const instance = ((portInRequestSid, phoneNumberSid) => instance.get(portInRequestSid, phoneNumberSid));
    instance.get = function get(portInRequestSid, phoneNumberSid) {
        return new PortingPortInPhoneNumberContextImpl(version, portInRequestSid, phoneNumberSid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.PortingPortInPhoneNumberListInstance = PortingPortInPhoneNumberListInstance;
