const mongoose = require('mongoose');
const Schema = mongoose.Schema;
const MessageSchema = new Schema(
    {
        sender: {
            type: String,
            required: true,
            min: 6,
            max: 255
        },
        receiver: {
            type: String,
            required: true,
            min: 4,
            max: 255
        },
        content: {
            type: String
        }
    },
    { timestamps: true }
);

module.exports = mongoose.model('Messages', MessageSchema);