// controllers/BaseController.js
class BaseController {
    constructor(service) {
      this.service = service;
    }
  
    getAll = async (req, res) => {
      return this.service.getAll(req, res);
    }
  
    getById = async (req, res) => {
      const id = parseInt(req.params.id);
      return this.service.findOne(id, res);
    }
  
    create = async (req, res) => {
      return this.service.add(req, res);
    }
  
    delete = async (req, res) => {
        const id = parseInt(req.params.id);
        return this.service.delete(id, res);
    }
  }
  
  module.exports = BaseController;