const jwt = require("jsonwebtoken");

module.exports = function (req, res, next) {
  const token = req.header("Authorization");
  if (!token) return res.status(401).send("Token Missing");

  try {
    // Decode the token to extract user information
    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    req.user = decoded;
    const secret = process.env.JWT_SECRET;
    const verified = jwt.verify(token, secret);
    req.user = verified;

    next();
  } catch (error) {
    return res.status(401).json({
      msg: "Invalid Token",
      error: error,
    });
  }
};
