"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginVersionArchiveListInstance = exports.PluginVersionArchiveInstance = exports.PluginVersionArchiveContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class PluginVersionArchiveContextImpl {
    constructor(_version, pluginSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(pluginSid)) {
            throw new Error("Parameter 'pluginSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { pluginSid, sid };
        this._uri = `/PluginService/Plugins/${pluginSid}/Versions/${sid}/Archive`;
    }
    update(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        const headers = {};
        if (params["flexMetadata"] !== undefined)
            headers["Flex-Metadata"] = params["flexMetadata"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new PluginVersionArchiveInstance(operationVersion, payload, instance._solution.pluginSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PluginVersionArchiveContextImpl = PluginVersionArchiveContextImpl;
class PluginVersionArchiveInstance {
    constructor(_version, payload, pluginSid, sid) {
        this._version = _version;
        this.sid = payload.sid;
        this.pluginSid = payload.plugin_sid;
        this.accountSid = payload.account_sid;
        this.version = payload.version;
        this.pluginUrl = payload.plugin_url;
        this.changelog = payload.changelog;
        this._private = payload.private;
        this.archived = payload.archived;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.url = payload.url;
        this._solution = {
            pluginSid: pluginSid || this.pluginSid,
            sid: sid || this.sid,
        };
    }
    get _proxy() {
        this._context =
            this._context ||
                new PluginVersionArchiveContextImpl(this._version, this._solution.pluginSid, this._solution.sid);
        return this._context;
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            sid: this.sid,
            pluginSid: this.pluginSid,
            accountSid: this.accountSid,
            version: this.version,
            pluginUrl: this.pluginUrl,
            changelog: this.changelog,
            _private: this._private,
            archived: this.archived,
            dateCreated: this.dateCreated,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PluginVersionArchiveInstance = PluginVersionArchiveInstance;
function PluginVersionArchiveListInstance(version) {
    const instance = ((pluginSid, sid) => instance.get(pluginSid, sid));
    instance.get = function get(pluginSid, sid) {
        return new PluginVersionArchiveContextImpl(version, pluginSid, sid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.PluginVersionArchiveListInstance = PluginVersionArchiveListInstance;
