const SequelizeSlugify= require('sequelize-slugify');
module.exports = (sequelize,DataTypes)=>{
    const vendors=sequelize.define("vendors",{

        name:{
          type: DataTypes.STRING
         },
        business_name:{
            type: DataTypes.STRING
           },
        username:{
            type: DataTypes.STRING,
             unique: true
        },
        slug:{
            type: DataTypes.STRING,
            unique: true
        },
        phone:{
            type: DataTypes.STRING,
            unique: true
        },
        business_phone:{
            type: DataTypes.STRING,
        },
        notification_token: {
            type: DataTypes.TEXT, // Changed from STRING to TEXT
          },
        subType:{
            type: DataTypes.BIGINT,
        },
        address_id:{
            type: DataTypes.BIGINT
        },
        description:{
            type: DataTypes.STRING,
        },
        summary:{
            type: DataTypes.STRING,
        },
        f_price:{
            type: DataTypes.STRING,
        },
        facebook_page_link:{
            type: DataTypes.STRING,
        },
        instagram_page_link:{
            type: DataTypes.STRING,
        },
        website_link:{
            type: DataTypes.STRING,
        },
        status:{
            type: DataTypes.BIGINT
        },
    
    },{
        tableName:"vendors"
    });

    SequelizeSlugify.slugifyModel(vendors, {
        source: ['name']
    });

    
    return vendors;
  }