const { Sequelize, DataTypes } = require('sequelize');
require('dotenv/config');

// const sequelize = new Sequelize(process.env.LOCAL_DB_NAME,
//   process.env.LOCAL_DB_UNAME,
//   process.env.LOCAL_DB_PASS,
//   {
//      host: process.env.LOCAL_DB_HOST,
//      dialect: 'mysql',
//      logging:false,
//      pool:{max:5,min:0,idle:10000},
//      logging: console.log
//    });


    const sequelize = new Sequelize(process.env.WEDDING_DB_PRO_NAME,
    process.env.WEDDING_DB_PRO_UNAME,
    process.env.WEDDING_DB_PRO_PASS,
    {
       host: process.env.WEDDING_DB_PRO_HOST,
       port:process.env.WEDDING_DB_PRO_PORT,
       dialect: 'mysql',
       logging:false,
       pool:{max:5,min:0,idle:10000}
     });  


  //  const sequelize = new Sequelize(process.env.WEDDING_DB_NAME,
  //   process.env.WEDDING_DB_UNAME,
  //   process.env.WEDDING_DB_PASS,
  //   {
  //      host: process.env.WEDDING_DB_HOST,
  //      port:process.env.WEDDING_DB_PORT,
  //      dialect: 'mysql',
  //      logging:false,
  //      pool:{max:5,min:0,idle:10000}
  //    });  


 

sequelize.authenticate()
  .then(() => {
    console.log('Connection has been  successfully.');
  })
  .catch(error => {
    console.error('Unable to connect to the database:', error);
  });


 


// Define the global scope
const globalScope = {
  defaultScope: {
    where: {
      // Add your common where clause here
      // For example, filtering out records where "is_deleted" is true
      active: true,
    },
  },
};

sequelize.addHook('beforeDefine', (attributes, options) => {
  if (options.modelName) {
    options.defaultScope = globalScope.defaultScope;
  }
  attributes.update_by = {
    type: DataTypes.STRING
  },
    attributes.id = {
      type: DataTypes.BIGINT,
      primaryKey: true,
      autoIncrement: true
    },
    attributes.active = {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    }
});

const db = {};
db.Sequelize = Sequelize;
db.sequelize = sequelize;

db.vendorCategories = require('./entities/vendorCategories')(sequelize, DataTypes);
db.locations = require('./entities/locations')(sequelize, DataTypes);
db.addresses = require('./entities/addresses')(sequelize, DataTypes);
db.packageDetails = require('./entities/packageDetails')(sequelize, DataTypes);
db.subVendors = require('./entities/subVendors')(sequelize, DataTypes);
db.users = require('./entities/users')(sequelize, DataTypes);
db.vendorMedia = require('./entities/vendorMedia')(sequelize, DataTypes);
db.vendorPackages = require('./entities/vendorPackages')(sequelize, DataTypes);
db.vendorReviews = require('./entities/vendorReviews')(sequelize, DataTypes);
db.vendors = require('./entities/vendors')(sequelize, DataTypes);
db.bookings = require('./entities/bookings')(sequelize, DataTypes);
db.auth= require('./entities/auth')(sequelize, DataTypes);
db.vendorPrices= require('./entities/vendorPrices')(sequelize, DataTypes);
db.bookedSlots= require('./entities/bookedSlots')(sequelize, DataTypes);
db.answers= require('./entities/answers')(sequelize, DataTypes);
db.albums= require('./entities/albums')(sequelize, DataTypes);
db.questions= require('./entities/questions')(sequelize, DataTypes);
db.vendorsAnswers= require('./entities/vendorsAnswers')(sequelize, DataTypes);
db.vendorsLockedDates= require('./entities/vendorsLockedDates')(sequelize, DataTypes);
db.subscriptionPlan= require('./entities/subscriptionPlan')(sequelize, DataTypes);
db.vendorSubscription= require('./entities/vendorSubscription')(sequelize, DataTypes);
db.vendorCatBridge= require('./entities/vendorCatBridge')(sequelize, DataTypes);
db.notification = require('./entities/notifications')(sequelize, DataTypes);
db.leads= require('./entities/leads')(sequelize, DataTypes);
db.adminDetail= require('./entities/adminDetail')(sequelize, DataTypes);
db.views= require('./entities/views')(sequelize, DataTypes);

// foreignKey

//db.category.hasMany(db.category , {foreignKey: 'parent_id'});
//db.category.belongsTo(db.category , {foreignKey: 'parent_id', as: 'pCategory' });

db.subscriptionPlan.hasMany(db.vendorSubscription, { foreignKey: 'sub_plan_id' });
db.vendorSubscription.belongsTo(db.subscriptionPlan, { foreignKey: 'sub_plan_id' });


// db.vendorCategories.hasMany(db.vendors, { foreignKey: 'category_id' });
// db.vendors.belongsTo(db.vendorCategories, { foreignKey: 'category_id' });

db.vendorCategories.hasMany(db.questions, { foreignKey: 'vendor_category_id' });
db.questions.belongsTo(db.vendorCategories, { foreignKey: 'vendor_category_id' });


db.vendorCategories.hasMany(db.vendorCatBridge, { foreignKey: 'vendor_category_id' });
db.vendorCatBridge.belongsTo(db.vendorCategories, { foreignKey: 'vendor_category_id' });

db.questions.hasMany(db.vendorsAnswers, { foreignKey: 'question_id' });
db.vendorsAnswers.belongsTo(db.questions, { foreignKey: 'question_id' });

db.users.hasMany(db.vendorReviews, { foreignKey: 'user_id' });
db.vendorReviews.belongsTo(db.users, { foreignKey: 'user_id' });

db.users.hasMany(db.bookings, { foreignKey: 'user_id' });
db.bookings.belongsTo(db.users, { foreignKey: 'user_id' });

db.users.hasMany(db.answers, { foreignKey: 'user_id' });
db.answers.belongsTo(db.users, { foreignKey: 'user_id' });

db.users.hasMany(db.leads, { foreignKey: 'user_id' });
db.leads.belongsTo(db.users, { foreignKey: 'user_id' });

db.vendors.hasMany(db.leads, { foreignKey: 'vendor_id' });
db.leads.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorsLockedDates, { foreignKey: 'vendor_id' });
db.vendorsLockedDates.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorSubscription, { foreignKey: 'vendor_id' });
db.vendorSubscription.belongsTo(db.vendors, { foreignKey: 'vendor_id' });


db.vendors.hasMany(db.vendorsAnswers, { foreignKey: 'vendor_id' });
db.vendorsAnswers.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.bookings, { foreignKey: 'vendor_id' });
db.bookings.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorReviews, { foreignKey: 'vendor_id' });
db.vendorReviews.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorCatBridge, { foreignKey: 'vendor_id' });
db.vendorCatBridge.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.subVendors, { foreignKey: 'vendor_id' });
db.subVendors.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorPackages, { foreignKey: 'vendor_id' });
db.vendorPackages.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorMedia, { foreignKey: 'vendor_id' });
db.vendorMedia.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.albums.hasMany(db.vendorMedia, { foreignKey: 'album_id' });
db.vendorMedia.belongsTo(db.albums, { foreignKey: 'album_id' });

db.vendors.hasMany(db.albums, { foreignKey: 'vendor_id' });
db.albums.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.bookedSlots, { foreignKey: 'vendor_id' });
db.bookedSlots.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.vendorPrices, { foreignKey: 'vendor_id' });
db.vendorPrices.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.vendors.hasMany(db.notification, { foreignKey: 'vendor_id' });
db.notification.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.subVendors.hasMany(db.vendorMedia, { foreignKey: 'subvendor_id' });
db.vendorMedia.belongsTo(db.subVendors, { foreignKey: 'subvendor_id' });

db.subVendors.hasMany(db.bookings, { foreignKey: 'subvendor_id' });
db.bookings.belongsTo(db.subVendors, { foreignKey: 'subvendor_id' });

db.subVendors.hasMany(db.bookedSlots, { foreignKey: 'subvendor_id' });
db.bookedSlots.belongsTo(db.subVendors, { foreignKey: 'subvendor_id' });

db.subVendors.hasMany(db.vendorPrices, { foreignKey: 'subvendor_id' });
db.vendorPrices.belongsTo(db.subVendors, { foreignKey: 'subvendor_id' });


db.vendorPackages.hasMany(db.bookings, { foreignKey: 'package_id' });
db.bookings.belongsTo(db.vendorPackages, { foreignKey: 'package_id' });

db.vendorPackages.hasMany(db.packageDetails, { foreignKey: 'package_id' });
db.packageDetails.belongsTo(db.vendorPackages, { foreignKey: 'package_id' });

db.vendorPackages.hasMany(db.bookedSlots, { foreignKey: 'package_id' });
db.bookedSlots.belongsTo(db.vendorPackages, { foreignKey: 'package_id' });

db.vendorPackages.hasMany(db.vendorPrices, { foreignKey: 'package_id' });
db.vendorPrices.belongsTo(db.vendorPackages, { foreignKey: 'package_id' });


db.addresses.hasMany(db.bookings, { foreignKey: 'address_id' });
db.bookings.belongsTo(db.addresses, { foreignKey: 'address_id' })

db.addresses.hasMany(db.vendors, { foreignKey: 'address_id' });
db.vendors.belongsTo(db.addresses, { foreignKey: 'address_id' });


db.locations.hasMany(db.addresses, { foreignKey: 'location_id' });
db.addresses.belongsTo(db.locations, { foreignKey: 'location_id' });

// db.vendorCategories.hasMany(db.subscriptionPlan, { foreignKey: 'category_id' });
// db.subscriptionPlan.belongsTo(db.vendorCategories, { foreignKey: 'category_id' });

db.users.hasMany(db.views, { foreignKey: 'user_id' });
db.views.belongsTo(db.users, { foreignKey: 'user_id' });

db.vendors.hasMany(db.views, { foreignKey: 'vendor_id' });
db.views.belongsTo(db.vendors, { foreignKey: 'vendor_id' });

db.locations.hasMany(db.users, { foreignKey: 'location_id' });
db.users.belongsTo(db.locations, { foreignKey: 'location_id' });



db.vendorCategories.hasMany(db.vendorCategories, { as: 'children', foreignKey: 'parent_id' });
db.vendorCategories.belongsTo(db.vendorCategories, { as: 'parent', foreignKey: 'parent_id' });

db.sequelize.sync({force:false,alter:false})
  .then(() => {
    console.log('Re-sync database');
  })

module.exports = db;
