const router = require("express").Router();
const VendorCategoryService = require("../../services/vendorServices/vendorCategoryService.js");
const Verify = require('../../services/VendorVerifyToken.js');

let vendorCategoryService = new VendorCategoryService();


// /**
//  * @swagger
//  * /api/vendorcategories:
//  *   get:
//  *     summary: Get all Vendor Categories
//  *     tags: [VendorCategories]
//  *      security:
//  *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
//  *     responses:
//  *       '200':
//  *         description: Successful response
//  */


// router.get('/',Verify, async function (req, res) {
//     try {
//         await vendorCategoryService.getAllVendorCategories(req , res);
//     }
//     catch (e) {
//         console.log(e);
//     }
// });


/**
 * @swagger
 * /api/vendorcategories/add:
 *   post:
 *     summary: Create a new vendor category
 *     tags: [VendorCategories]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - name
 *             properties:
 *               name:
 *                 type: string
 *     responses:
 *       '201':
 *         description: Created successfully
 *       '400':
 *         description: Bad Request
 */

router.post('/add', async function (req, res) {
    try {
        await vendorCategoryService.addCategory(req , res);
    }
    catch (e) {
        console.log(e);
    }
});



/**
 * @swagger
 * /api/vendorcategories:
 *   get:
 *     summary: Get all vendor categories.
 *     tags: [VendorCategories]
 *     parameters:
 *       - in: query
 *         name: parentId
 *         description: ID of the parent category. If provided, fetch children categories of the specified parent; otherwise, fetch only parent categories.
 *         schema:
 *           type: integer
 *     responses:
 *       '200':
 *         description: A list of vendor categories.
 *       '500':
 *         description: Internal Server Error.
 */
router.get('/', async function (req, res) {
    try {
        await vendorCategoryService.getAllVendorCategories(req , res);
    }
    catch (e) {
        console.log(e);
    }
});



module.exports = router;