const BaseController = require('./baseController.js');
const LocationService = require('../services/LocationService.js');
const Verify = require('../services/VendorVerifyToken.js');


class LocationController extends BaseController {
    constructor() {
        let locationService =new LocationService();
        super(locationService);
    }
 }

 const locationController = new LocationController();
 const router = require("express").Router();

 const locationService = new LocationService();
/**
 * @swagger
 * tags:
 *   name: Location
 *   description: API for managing locations
 */

/**
 * @swagger
 * /api/location:
 *   get:
 *     summary: Get all Locations
 *     tags: [Location]
 *     parameters:
 *       - in: query
 *         name: page
 *         description: Page number for pagination | default value 0
 *         schema:
 *           type: integer
 *       - in: query
 *         name: pageSize
 *         description: Number of items per page| default value 10
 *         schema:
 *           type: integer
 *     responses:
 *       '200':
 *         description: Successful response
 */
router.get('/', locationController.getAll.bind(locationController));

/**
 * @swagger
 * /api/location/{locationId}:
 *   get:
 *     summary: Get Location by Location  ID
 *     tags: [Location] 
 *     description: Retrieve Location based on the Location ID.
 *     parameters:
 *       - in: path
 *         name: locationId
 *         schema:
 *           type: integer
 *         required: true
 *         description: ID of the location whose locations are to be retrieved.
 *     responses:
 *       '200':
 *         description: A list of locations.
 *       '404':
 *         description: not found.
 *       '500':
 *         description: Internal server error.
 */
router.get('/:locationId',async (req, res) => {
    await locationService.getlocationById(req, res);
  });
module.exports = router;