const router = require('express').Router();
const Response = require('../../models/Response');
const AuthService = require('../../services/authServices/AuthService');
const multer = require('multer');
const upload = multer({ dest: 'uploads/' })

const authService = new AuthService();

/**
 * @swagger
 * tags:
 *   name: Authentication
 *   description: API for managing authentication
 */

/**
 * @swagger
 * /api/auth/authentication:
 *   post:
 *     summary: Auth
 *     tags: [Authentication]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               phone:
 *                 type: string 
 *               userType:
 *                 enum: [ "customer", "vendor"]
 *                 required: true
 *     responses:
 *       '200':
 *         description: Successful response
 *       '400':
 *         description: Invalid Input
 */
router.post('/authentication' , async (req , res) => {
    await authService.authUser(req, res);
});

/**
 * @swagger
 * /api/auth/verfication:
 *   post:
 *     summary: verfication
 *     tags: [Authentication]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - phoneNumber
 *               - code
 *               - userType
 *             properties:
 *               phoneNumber:
 *                 type: string
 *               code:
 *                 type: integer
 *               userType:
 *                 enum: [ "customer", "vendor"]
 *     responses:
 *       '200':
 *         description: Successful response
 *       '400':
 *         description: Invalid Input
 */
router.post('/verfication' , async (req , res) => {
    await authService.verifyUser(req, res);
});



// /**
//  * @swagger
//  * /api/auth/signup:
//  *   post:
//  *     summary: Sign Up
//  *     tags: [Authentication]
//  *     requestBody:
//  *       required: true
//  *       content:
//  *         application/json:
//  *           schema:
//  *             type: object
//  *             properties:
//  *               name:
//  *                 type: string
//  *               username:
//  *                 type: string
//  *               password:
//  *                 type: string
//  *               city:
//  *                 type: string
//  *               phone:
//  *                 type: string
//  *               userType:
//  *                 enum: [ "customer", "vendor"]
//  *                 required: true
//  *                 description: |
//  *                    If userType is "customer," both 'username' and 'password' are not required.
//  * 
//  *     responses:
//  *       '200':
//  *         description: Successful response
//  *       '400':
//  *         description: Invalid Input
//  */
// router.post('/signup', async (req, res) => {
//     await authService.registerUser(req, res);
//   });


/**
 * @swagger
 * /api/auth/profileSetup:
 *   post:
 *     summary: Create Profile
 *     tags: [Authentication]
 *     requestBody:
 *       required: false
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               phone:
 *                 type: string
 *               businessName:
 *                 type: string
 *               name:
 *                 type: string
 *               parentId:
 *                  type: integer
 *               categoryIds:
 *                 type: array
 *                 items:
 *                   type: integer
 *               userType:
 *                 type: string
 *               businessphone:
 *                 type: string
 *               locationId:
 *                 type: integer
 *               address:
 *                 type: string
 *     responses:
 *       '200':
 *         description: User profile created successfully
 *       '400':
 *         description: Invalid request or missing required fields
 *       '500':
 *         description: Internal server error
 */
router.post('/profileSetup', async (req, res) => {
    await authService.profileSetup(req, res);
  });


 /**
 * @swagger
 * /api/auth/resendCode:
 *   put:
 *     summary: resendCode
 *     tags: [Authentication]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               phoneNumber:
 *                 type: string 
 *               userType:
 *                 enum: [ "customer", "vendor"]
 *                 required: true
 *     responses:
 *       '200':
 *         description: Successful response
 *       '400':
 *         description: Invalid Input
 */
router.put('/resendCode' , async (req , res) => {
    await authService.resendCode(req, res);
}); 

/**
 * @swagger
 * /api/auth/updateNotification:
 *   put:
 *     summary: Update notification token
 *     tags: [Authentication]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - phone
 *               - newNotificationToken
 *               - userType
 *             properties:
 *               phone:
 *                 type: string
 *                 description: Phone number of the user/vendor
 *               newNotificationToken:
 *                 type: string
 *                 description: New notification token
 *               userType:
 *                 type: string
 *                 enum: [customer, vendor]
 *                 description: Type of user (customer or vendor)
 *     responses:
 *       200:
 *         description: Notification token updated successfully
 *       400:
 *         description: Invalid user type or missing parameters
 *       404:
 *         description: User/vendor not found
 *       500:
 *         description: Internal server error
 */
 router.put('/updateNotification' , async (req , res) => {
    await authService.updateNotificationToken(req , res);
}); 

/**
 * @swagger
 * /api/auth/upload-csv:
 *   post:
 *     summary: Upload CSV to bulk insert vendors
 *     tags: [Authentication]
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             required:
 *               - file
 *               - parentId
 *               - locationId
 *               - categoryArray
 *             properties:
 *               file:
 *                 type: string
 *                 format: binary
 *                 description: CSV file containing vendor data with columns like Name, Contact, Location, Facebook
 *               parentId:
 *                 type: integer
 *                 example: 1
 *                 description: Parent category ID for the vendor
 *               locationId:
 *                 type: integer
 *                 example: 1
 *                 description: Location ID where the vendor is registered
 *               categoryArray:
 *                 type: Array
 *                 example: "[3,4,5]"
 *                 description: JSON array of category IDs (e.g. "[3,4,5]"). Must be stringified JSON in form-data.
 *     responses:
 *       200:
 *         description: Vendors processed successfully
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 statusCode:
 *                   type: integer
 *                 message:
 *                   type: string
 *                 data:
 *                   type: object
 *                   properties:
 *                     summary:
 *                       type: array
 *                       items:
 *                         type: object
 *                         properties:
 *                           phone:
 *                             type: string
 *                           success:
 *                             type: boolean
 *                           message:
 *                             type: string
 *       400:
 *         description: Missing or invalid CSV file or input parameters
 *       500:
 *         description: Internal server error
 */


router.post('/upload-csv',upload.single('file'),async (req, res) => {
    await authService.InsertVendorFromCSV(req, res);
  }
);



module.exports = router;